
**************************************************************
*  MACRO NAME:         MKAPPASC.SPS                          *
*                                                            *
*  README FILE:        MKAPPASC.RM                           *
*                                                            *
*  SPSS REQUIREMENTS:  Release 4.0 or above                  *
*                      Advanced Statistics Module            *
*                                                            *
*  AUTHOR:             David Nichols (nichols@spss.com)      *
*                                                            *
*  LAST UPDATED:       04/08/97                              *
**************************************************************

preserve.
set printback=off mprint=off.
save outfile='ka__tmp1.sav'.
define mkappasc (vars=!charend('/')).
set mxloops=1000.
count ms__=!vars (missing).
select if ms__=0.
matrix.
get x /var=!vars.
compute c=mmax(x).
compute y=make(nrow(x),c,0).
loop i=1 to nrow(x).
loop j=1 to ncol(x).
loop k=1 to c.
do if x(i,j)=k.
compute y(i,k)=y(i,k)+1.
end if.
end loop.
end loop.
end loop.
compute pe=msum((csum(y)/msum(y))&**2).
compute k=ncol(x).
compute pa=mssq(y)/(nrow(y)*k*(k-1))-(1/(k-1)).
compute kstat=(pa-pe)/(1-pe).
compute num=2*(pe-(2*k-3)*(pe**2)+2*(k-2)*msum((csum(y)/msum(y))&**3)).
compute den=nrow(y)*k*(k-1)*((1-pe)**2).
compute ase=sqrt(num/den).
compute z=kstat/ase.
compute sig=1-chicdf(z**2,1).
save {kstat,ase,z,sig} /outfile='ka__tmp2.sav'
     /variables=kstat,ase,z,sig.
end matrix.
get file='ka__tmp2.sav'.
formats all (f11.8).
variable labels kstat 'Kappa' /ase 'ASE' /z 'Z-Value' /sig 'P-Value'.
report format=list automatic align(center)
  /variables=kstat ase z sig
  /title "Estimated Kappa, Asymptotic Standard Error,"
         "and Test of Null Hypothesis of 0 Population Value".
get file='ka__tmp1.sav'.
!enddefine.
restore.
